"""Module for helper functions and group-wide utilities"""
from time import sleep
import subprocess
from .config import * 
from mtf.libs.mtf_pybinder import Ecu,mtf_someip_filter,mtf_ipv4_layer_filter,mtf_udp_layer_filter,mtf_eth_app_layer_filter,mtf_eth_protocol_type
from mtf.libs.mtf_pybinder.mtf_datamodel_services import Event, Method, ConsumedService, RequestType, EventGroup, ServiceInterface, FindEntrySdParameters, OfferEntrySdParameters, ProvidedService, ConsumedEventGroup, SubscribeEntrySdParameters
from mtf.libs.mtf_pybinder.mtf_someip_datatypes import StructDataType,BaseDataType,EnumDataType,ServiceParameter
from mtf.libs.mtf_pybinder.mtf_datamodel_system_topology import SomeIpEcuDataModel


def get_current_ipv4(adapter):
    output = subprocess.check_output(f'netsh interface ip show address name="{adapter}"', shell=True, text=True)
    for line in output.splitlines():
        if "IP Address" in line or "IP Address:" in line:
            return line.split(":")[-1].strip()
    return None

def change_ip(ip, adapter):
    current_ipv4 = get_current_ipv4(adapter)
    if current_ipv4 != ip:
        print(f"Changing IPv4 from {current_ipv4} to {ip}")
        change_ipv4 = f'netsh interface ip set address name="{adapter}" static {ip} 255.255.0.0'
        subprocess.call(change_ipv4.split())
    else:
        print("IPv4 already set to desired value. Skipping.")

    sleep(2)

def create_someip_filter(ip_src,service_id,method_id,msgType,returnCode):
    ipv4_layer_filter = mtf_ipv4_layer_filter()
    ipv4_layer_filter.ip_srcs = ip_src

    udp_layer_filter = mtf_udp_layer_filter()
    udp_layer_filter.prev_layer_filter = ipv4_layer_filter

    eth_app_layer_filter = mtf_eth_app_layer_filter()
    eth_app_layer_filter.app_layer_protocol_type = mtf_eth_protocol_type.SOME_IP
    eth_app_layer_filter.prev_layer_filter = udp_layer_filter

    someip_filters = mtf_someip_filter()
    someip_filters.services_ids = service_id
    someip_filters.methods_ids = method_id
    someip_filters.msg_type = msgType
    if returnCode is not None:
        someip_filters.return_code = returnCode
    someip_filters.prev_layer_filter = eth_app_layer_filter

    return someip_filters

def createConsumedEventGroup(EventGroups):
    Consumed_event_group = ConsumedEventGroup(EventGroups, 
                                              SubscribeEntrySdParameters())
    return Consumed_event_group

def create_someip_nodes():
   
   # Specify the SOME/IP event and method used for communication between the two configured nodes.
   Event_service1 = Event(EVENT_STRUCT_NAME,
                          METHOD_ID_1,
                          reliable=False,
                          cycle_in_ms=200)
   
   Method_service2 = Method(METHOD_NAME,
                            METHOD_ID_2,
                            reliable=False,
                            request_type=RequestType.REQUEST_RESPONSE)
   
   # Define the SOME/IP members:
   # - The event includes a struct with four basic members.
   # - The method includes a simple input and output parameter.
   Event_Struct= StructDataType(EVENT_STRUCT_NAME)
   Event_Struct.insert_member(0,BaseDataType.create_basic_data_type(short_name=FIRST_MEMBER_NAME,
                                                                    basic_data_type=DATA_TYPE_UINT_8,
                                                                    bit_length=8))
   
   Event_Struct.insert_member(1,BaseDataType.create_basic_data_type(short_name=SECOND_MEMBER_NAME,
                                                                    basic_data_type=DATA_TYPE_UINT_8,
                                                                    bit_length=8,
                                                                    is_big_endian=True))
   
   Event_Struct.insert_member(2,EnumDataType(THIRD_MEMBER_NAME,
                                             DATA_TYPE_UINT_16,
                                             16,
                                             is_big_endian=False))
   
   Event_Struct.insert_member(3,EnumDataType(FOURTH_MEMBER_NAME,
                                             DATA_TYPE_UINT_8,
                                             8,
                                             is_big_endian=True))
   
   Event_service1.parameters={1:ServiceParameter(Event_Struct)}

   Method_service2.input_parameters={1:ServiceParameter(BaseDataType.create_basic_data_type(INPUT_PARAMETER_NAME,
                                                                                            DATA_TYPE_UINT_32,
                                                                                            32))}
   
   Method_service2.output_parameters={1:ServiceParameter(BaseDataType.create_basic_data_type(RETURN_PARAMETER_NAME,
                                                                                             DATA_TYPE_UINT_8,
                                                                                             8))}
   
   # Define an event group that includes the event and is used 
   # for subscription between the provider and the consumer.
   EventGroups = EventGroup(identifier=1).add_events([Event_service1])
   
   # Include the event, event group and method in one service.
   Service1_def = ServiceInterface(SERVICE_NAME,
                                   identifier=SERVICE_ID_1,
                                   major_version=2,
                                   minor_version=0)
   
   Service1_def.add_events([Event_service1])
   Service1_def.add_events_groups([EventGroups])
   Service1_def.add_methods([Method_service2])
   
   # Define the first ECU with its IP address and port.
   # The defined service will be used as a consumed service for this ECU.
   Node_1=SomeIpEcuDataModel(FIRST_NODE_NAME,
                             IP_64).configure_someipsd(IP_SD,
                                                       SD_PORT)

   Node_1_consumed_service = ConsumedService(instance_id=1,
                                             service=Service1_def,
                                             sd_parameters=FindEntrySdParameters()).add_events_groups([createConsumedEventGroup(EventGroups)])
   Node_1.add_someip_end_point(SOMEIP_PORT_1,
                               SOMEIP_TRANSPORT_PROTOCOL,
                               [],
                               [Node_1_consumed_service])
   
   # Define the second ECU with its IP address, port and the same someipsd configuration.
   # The defined service will be used as a provider service for this ECU.
   Node_2=SomeIpEcuDataModel(SECOND_ECU_NAME,
                             IP_57).configure_someipsd(IP_SD,
                                                       SD_PORT)

   Node_2_provided_service=ProvidedService(instance_id=1,
                                           service=Service1_def,
                                           sd_parameters=OfferEntrySdParameters())
   
   Node_2.add_someip_end_point(SOMEIP_PORT_2,
                               SOMEIP_TRANSPORT_PROTOCOL,
                               [Node_2_provided_service],
                               [])
   
   Ecu2 = Ecu.create(Node_1)
   Ecu4 = Ecu.create(Node_2)

   
   return Ecu2,Ecu4
