from .switch_undefined_cycle_fixture import SwitchUndefinedCycleFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_try_switch_undefined_cycle_can",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaTrySwitchUndefinedCycleCAN(SwitchUndefinedCycleFixture):
    def setUp(self):
        self.logger.info("tca_try_switch_undefined_cycle_can starting")

    # Create the test case core method that holds the main test steps.
    def test_switch_undefined_cycle_can(self):
        
        # Define a channel from the database with the appropriate channel name.
        channel = self.com_network.try_get_channel_by_name(CHANNEL_NAME)
        
        self.assertTrue(channel,
                        Severity.BLOCKER,
                        "Channel is not defined")
        
        frame =  channel.get_frame_by_id(FRAME_ID) 
        
        # Start frame transmission with the cycle defined from the DB.
        # Based on the frame id and channel name, the original cycle 
        # for this frame is 100 ms(according to the DB).
        frame.start_transmission()
        sleep(0.2)
        
        # Change the cycle to a user defined value.
        # The specified value must be provided in milliseconds.
        frame.try_switch_to_undefined_cycle(WRONG_CYCLE)
        
        can_frame_listener = self.can_frame_listener(CHANNEL_NAME,FRAME_ID)
        
        # Create a listener to capture the transmitted frames with the timestamp. 
        can_frame_listener.start_listening()
        
        sleep(2)
        
        # Stop the listener.
        can_frame_listener.stop_listening()
        
        # Get a list of captured frames from the queue.
        frames= can_frame_listener.get_queue()
        
        timestamp =[]
        
        self.assertNotEqual(frames.qsize(),
                            0,
                            Severity.BLOCKER,
                            "Listener is empty")
        
        # Create a timestamp list.
        for fr in frames.queue:
            timestamp.append(fr.timestamp)
        
        # Calculate the difference between each pair of consecutive timestamps
        # and verify that the transmission with the predefined cycle time is respected.
        for i in range(1,len(timestamp)):
            
            # The listener timestamp is returned in nanoseconds.
            # To unify the time units between timestamp and cycle, we convert
            # also the timestamp to milliseconds by dividing it by 1E6. 
            delta=(timestamp[i]-timestamp[i-1])/ 1E6
            
            # The difference should be within the average range between the 
            # min cycle and max cycle provided also in milliseconds(can be found in the DB)
            self.assertTrue(390 <= int(delta) <= 410,
                            Severity.BLOCKER,
                            "New cycle is not respected") 
        
        # Reset the listener to clear all previously received data.
        can_frame_listener.reset()
        
        # Cancel the use of the modified transmission cycle.
        frame.cancel_undefined_cycle()
        sleep(0.5)
        
        # Start again the listener. 
        can_frame_listener.start_listening()
        sleep(2)
        
        can_frame_listener.stop_listening()
        
        # Retrieve all received frames in one list.
        frames=can_frame_listener.get_queue()

        timestamp =[]
        
        self.assertNotEqual(frames.qsize(),
                            0,
                            Severity.BLOCKER,
                            "Listener is empty")
        
      
        # Define a new timestamp list. 
        for fr in frames.queue:
            timestamp.append(fr.timestamp)
        
        # Verify that the original cycle is respected
        # and not the modified one.
        for i in range(1,len(timestamp)):
            
            delta=(timestamp[i]-timestamp[i-1])/1E6
            
            self.assertTrue(90 <= int(delta) <= 110,
                            Severity.BLOCKER,
                            "Cycle is not returned to the DB defined value")
        
        # Stop the transmission.
        frame.stop_transmission()

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_try_switch_undefined_cycle_can stopping")