"""Module for helper functions and group-wide utilities"""
from time import sleep

from mtf.libs.mtf_pybinder import mtf_mac_layer_filter,mtf_eth_protocol_type,mtf_ipv4_layer_filter,mtf_udp_layer_filter,mtf_eth_app_layer_filter
from mtf.network_port.eth_bus_listener import EthBusListener

def create_npdu_filter():
    
    # mtf_mac_layer_filter
    mac_filter = mtf_mac_layer_filter()
    mac_filter.mac_dsts = [0x01, 0x00, 0x5e, 0x40, 0xff, 0x02]
    mac_filter.mac_srcs = [0xff, 0xff, 0xff, 0xff, 0xff, 0xff]
        
    #  mtf_ipv6_layer_filter
    ipv4_layer_filter = mtf_ipv4_layer_filter()
    ipv4_layer_filter.ip_dsts =  [239, 192, 255, 2]
    ipv4_layer_filter.prev_layer_filter = mac_filter

    udp_layer_filter = mtf_udp_layer_filter()
    udp_layer_filter.dst_ports = {31338}
    udp_layer_filter.src_ports = {31302}
    udp_layer_filter.prev_layer_filter = ipv4_layer_filter

    eth_app_layer_filter = mtf_eth_app_layer_filter()
    eth_app_layer_filter.app_layer_protocol_type = mtf_eth_protocol_type.NPDU
    eth_app_layer_filter.prev_layer_filter = udp_layer_filter

    return eth_app_layer_filter
