from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_flexray_set_then_unset_interception_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)

class TcaFlexraySetUnsetInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_flexray_set_then_unset_interception_function starting")

    # Create the test case method that holds the main test steps.
    def test_flexray_set_then_unset_interception_function(self):
        
        # Set an interception with a callback function 'change_felxray' that will corrupt the payload 
        # before the transmission and inject it in the bus.
        set_function=self.flexray_channel(FR_CHANNEL_2).set_interception_function(change_felxray) 
        
        # Ensure the interception function was successfully set.
        self.assertTrue(set_function,
                        Severity.BLOCKER,
                        "set_function did not work properly.")
        
        # Disable the interception function to allow frames to be transmitted without modification.
        self.flexray_channel(FR_CHANNEL_2).unset_interception_function()
        
        # Send a FlexRay frame with a specific frame_id and payload, 
        # using continuous transmission mode.
        self.flexray_channel(FR_CHANNEL_2).send_frame(FlexRayDataFrame(frame_id=FLEXRAY_FRAME_ID,
                                                                       payload=FLEXRAY_PAYLOAD,
                                                                       com_channel=COMMUNICATION_CHANNEL,
                                                                       transmission_mode=TRANSMISSION_MODE,
                                                                       error_flags=0))
        
        # Start listening on FR_CHANNEL_1 to receive frames.
        self.flexray_channel(FR_CHANNEL_1).start_listening()
        
        sleep(2)
        
        self.flexray_channel(FR_CHANNEL_1).stop_listening()
        
        # Retrieve the history of received frames FR_CHANNEL_1.
        fr_queue=self.flexray_channel(FR_CHANNEL_1).get_history() 
       
        nbr_packet_with_expeted_id =0
        
        for fr_msg in fr_queue:
            # Decode frame_id into individual components.
            current_cycle = (fr_msg.frame_id >> 32) & 0xff
            slot_id = fr_msg.frame_id & 0xffff
            
            # Assert that the slot_id matches the expected value (wich equal to 5 in our case).
            self.assertTrue(slot_id == EXPECTED_SLOT_ID,
                            Severity.BLOCKER,
                            "Wrong slot_id.")
            
            # Check that the frame was received correctly on FR_CHANNEL_1 and has the expected payload.
            if (fr_msg.channel_name == FR_CHANNEL_1
                and fr_msg.direction == RX_DIRECTION
                and slot_id == EXPECTED_SLOT_ID
                and fr_msg.payload == [int(x) for x in FLEXRAY_PAYLOAD]
               ):
                
                nbr_packet_with_expeted_id+=1
                
                # Validate the current_cycle is within the expected transmission pattern .
                self.assertTrue(current_cycle in EXPECTED_CYCLE_LIST,
                                Severity.BLOCKER,
                                "wrong cycle received {0} expected list cycle {1}".format(current_cycle,EXPECTED_CYCLE_LIST))
       
        
        self.assertTrue(nbr_packet_with_expeted_id == len(fr_queue),
                        Severity.BLOCKER,
                        "Some Frames are not received.")
   
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_set_then_unset_interception_function stopping")
