from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_eth_with_intercept_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaEthWithInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_eth_with_intercept_function starting")

    # Create the test case method that holds the main test steps.
    def test_eth_set_intercept_function(self):

        # Clean up any existing Ethernet listener data for ETH_RECEIVER_NAME on Ethernet_II protocol.
        self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).clean_up() 
        
        # Start listening for incoming Ethernet frames on ETH_RECEIVER_NAME channel.
        self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME, 
                protocol=ETH_PROTOCOL).start_listening()
        
        # Create a base Ethernet message with pcpp decoder.
        eth_message=create_eth_msg()
        
        # Set an interception with a callback function 'change_eth_msg' that will 
        # corrupt the payload before the transmission and inject it in the bus.
        set_function=self.ethernet_channel(ETH_SENDER_NAME).set_interception_function(change_eth_msg)
        
        # Verify that the interception function was set successfully.
        self.assertTrue( set_function,Severity.BLOCKER,"set_function did not work properly.")  
        
       
        # Transmit the Ethernet message using a raw transmitter (e.g. via PcapPlusPlus)
        transmitter = mtf_ethernet_transmitter() 
        transmit = transmitter.transmit_ethernet_packet(ETH_SENDER_NAME, eth_message)
        
        # Verify the transmission was successful.
        self.assertTrue(transmit,
                        Severity.BLOCKER,
                        "transmission did not work properly.") 
        
        sleep(1)

        # Retrieve the received frames from the listener queue.
        self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).stop_listening()
        
        received_message=self.bus_manager.ethernet_listener(
                bus_name=ETH_RECEIVER_NAME,
                protocol=ETH_PROTOCOL).get_queue() 
        
        # Check if a frame with the expected (intercepted) payload was received.
        received_messages = 0
        
        for ethernet_message in received_message:
            if ethernet_message['payload'] == ETH_CORRUPTED_PAYLOAD: 
                received_messages = received_messages + 1
       
        
        self.assertTrue(received_messages==1,
                        Severity.BLOCKER,
                        "Message not received properly.")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_eth_with_intercept_function stopping")
