from time import sleep
from .interception_fixture import InterceptionFixture
from xtr import metadata, extra_metadata
from xtr import Severity
from .helper import *
from .config import *

@metadata(
    tc_id="tca_can_with_intercept_function",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanWithInterceptFunction(InterceptionFixture):
    def setUp(self):
        self.logger.info("tca_can_with_intercept_function starting")

    # Create the test case method that holds the main test steps.
    def test_transmit_can_frame_with_intercept_function(self):
        
        """
            This function demonstrates the behavior of the intercept function.
            An interception function will be set on the bus, which modifies
            the payload using a callback function during transmission.
        """

        self.can_channel(CAN_CHANNEL_NAME).start_listening()  
        
        sleep(0.5)
         
        # Set an interception with a callback function 'change' that will corrupt 
        # the payload before the transmission and injected in the bus.
        set_function=self.can_channel(CAN_CHANNEL_NAME).set_interception_function(change) 
       
        # Assert that the interception function was successfully set.
        self.assertTrue(set_function,Severity.BLOCKER,"set_function did not work properly.")
        
        # Send a CAN frame with a specific payload (that will be corrupted and modified).
        self.can_channel(CAN_CHANNEL_NAME).send_frame(CanDataFrame(CAN_FRAME_ID,CAN_PAYLOAD)) 
       
        # Stop listening on the channel to finalize frame capture.
        self.can_channel(CAN_CHANNEL_NAME).stop_listening()
       
        # Retrieve the history of received frames.
        liste_history=self.can_channel(CAN_CHANNEL_NAME).get_history()
        
        # Ensure that queue is not NULL.
        self.assertTrue(len(liste_history)==1,Severity.BLOCKER,"No frame is received.") 
        
        for can_msg in liste_history:
            self.assertTrue(
            can_msg.channel_name == CAN_CHANNEL_NAME and               # Must be received on the correct channel
            can_msg.direction == RX_DIRECTION and                      # Must be an incoming (Rx) frame
            can_msg.payload == CAN_CORRUPTED_PAYLOAD and               # Payload must reflect interception logic 
            can_msg.payload_length == 8 and                            # Frame should contain 8 bytes
            can_msg.frame_id == int(CAN_FRAME_ID),                     # Frame ID must match what was sent
            Severity.BLOCKER,
            "Frame is intercepted."
            )
      
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_with_intercept_function stopping")
