"""Module for helper functions and group-wide utilities"""
from time import sleep
from mtf.network_port.channels.channel_factory import ChannelFactory
from mtf.enum_types import BusType ,TransmissionMode, FRCommunicationChannel
from mtf.proto_common import EthProtocolType
from mtf.libs.mtf_pybinder import CanDataFrame,FlexRayDataFrame ,MtfDataFrameEvent,mtf_ethernet_transmitter,pcpp
from .config import *


def change(event:MtfDataFrameEvent):
    event.set_payload(CAN_CORRUPTED_PAYLOAD)

def change_felxray(event:MtfDataFrameEvent):
    event.set_payload(FLEXRAY_CORRUPTED_PAYLOAD)

def create_eth_msg():
    
    data_eth = bytes.fromhex("ffffffffffffaaabacada0a188a80010810000640800450000280000000020111772c0a80102c0a801010ce40ce5001462a7000000000000000000000001")
    eth_raw_pkt = pcpp.RawPacket(data_eth)
    eth_packet = pcpp.Packet(eth_raw_pkt)
    return eth_packet

def change_eth_msg(event:MtfDataFrameEvent):
    event.set_payload(ETH_CORRUPTED_PAYLOAD)