from .e2e_fixture import E2eFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_apply_faulty_crc",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaApplyFaultyCrc(E2eFixture):
    def setUp(self):
        self.logger.info("tca_apply_faulty_crc starting")

    # Create the test case core method that holds the main test steps.
    def test_apply_faulty_crc(self):
        # The expected CRC dictionary that will be filled 
        # with CRC values after restoration from corruption.
        expected_crc_not_corrupted = {}

        # Start the transmission of the frame with 
        # the specified id and on the specified channel_name
        self.legacy_frame(CHANNEL_NAME, FRAME_ID).start_transmission()
        
        # Apply faulty corrupt crc on the specified pdu. 
        # It will decrement the crc by 1.
        self.legacy_pdu(
            CHANNEL_NAME,
            FRAME_ID,
            PDU_NAME).apply_faulty_corrupt_crc(True)
        sleep(1)

        # Start listening on specified frame.
        self.can_frame_listener(
            CHANNEL_NAME,
            FRAME_ID).start_listening(
            silent_mode=True)
        sleep(2)

        # Stop the listener.
        self.can_frame_listener(CHANNEL_NAME, FRAME_ID).stop_listening()
        
        # Get the queue of captured can frames 
        # with the specified channel name and frame id.
        frames = self.can_frame_listener(CHANNEL_NAME, FRAME_ID).get_queue()
        
        for frame in frames.queue:
            # Update the expected_crc_not_corrupted dict with the restored corrected CRC values.
            # The keys of the dict are the alive of each pdu. Values represent the corrected CRC.
            expected_crc_not_corrupted[frame.payload[1] & 0XF] = frame.payload[0] + 1
        
        self.assertEqual(
            expected_crc_not_corrupted,
            ACTUAL_CRC_NOT_CORRUPTED,
            Severity.BLOCKER,"***Failure: CRC was corrupted")

        # Stop the transmission.
        self.legacy_frame(CHANNEL_NAME, FRAME_ID).stop_transmission()

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_apply_faulty_crc stopping")