from .bus_errors_and_events_fixture import BusErrorAndEventFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_flexray_listener_with_event_callback",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaFlexrayListenerWithEvent(BusErrorAndEventFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_flexray_listener_with_event_callback starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_flexray_listener_with_event_callback stopping")

    # Create the test case core method that holds the main test steps.
    def test_flexray_listener_with_event(self):

        # Create a specific listener to listen to flexray symbols.
        symbol_listener = FlexRaySymbolsListener(FR_CM_CHANNEL)

        symbol_listener.start_listening(callback=flexray_event_callback)
   
        # Transmit the flexray events list.
        transmit_packet([WAKE_UP_FR_EVENT])

        symbol_listener.stop_listening()

        nbr_wake_up = 0

        for flexray_event in actual_list_flexray:

            if is_wus(flexray_event):
                nbr_wake_up+=1
        
        # Check that the number of Rx frames captured by the listener 
        # is equal to EXPECTED_NBR_FR_EVENT_FRAMES.
        # Here we divided the number by 2 to only get the Rx frames without the Tx ones.
        self.assertEqual(nbr_wake_up/2,
                         EXPECTED_NBR_FR_EVENT_FRAMES,
                         Severity.BLOCKER,
                         "Wrong number of wakeUp event expected {0} but got {1}".format(nbr_wake_up, 
                                                                                        EXPECTED_NBR_FR_EVENT_FRAMES))