from .bus_errors_and_events_fixture import BusErrorAndEventFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_can_listener_with_error",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCanListenerWithError(BusErrorAndEventFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_can_listener_with_error starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_can_listener_with_error stopping")

    # Create the test case core method that holds the main test steps.
    def test_can_listener_with_error(self):

        can_listener = self.bus_manager.bus_listener(CAN_CM_CHANNEL, 
                                                     CAN_TYPE)
        
        # Start listening on can messages including error frames.
        can_listener.start_listening(silent_mode=True, 
                                     flags=INCLUDE_FRAMES_WITH_ERROR)
        
        # Start the transmission of four CAN frames with errors.
        transmit_packet([CRC_CAN_ERR, CRC_DEL_ERR, NOT_ACK_ERR, ACK_DEL_ERR])

        can_listener.stop_listening()

        can_error_messages_queue = can_listener.get_queue()

        # Check that the number of Rx frames captured by the listener 
        # is equal to EXPECTED_NBR_CAN_ERR_FRAMES.
        # Here we divided the number by 2 to only get the Rx frames without the Tx ones.
        self.assertEqual(can_error_messages_queue.qsize()/2,
                         EXPECTED_NBR_CAN_ERR_FRAMES,
                         Severity.BLOCKER,
                         "Number of captured frame {0} is not as expected {1}".format(can_error_messages_queue.qsize()/2,
                                                                                      EXPECTED_NBR_CAN_ERR_FRAMES))