"""Module for helper functions and group-wide utilities"""
from time import sleep
from mtf.enum_types import BusType
from mtf.libs.mtf_pybinder import ListeningFlags, FlexRaySymbolsListener, mtf_ethernet_transmitter, pcpp
import numpy as np
from .config import ETH_SWITCH_CHANNEL

def transmit_packet(packet_list):

    transmitter = mtf_ethernet_transmitter()
    for packet in packet_list:
        
        packet = pcpp.Packet(pcpp.RawPacket(packet))
            
        transmitter.transmit_ethernet_packet(ETH_SWITCH_CHANNEL,packet)
        sleep(1)

actual_list_flexray = []
def flexray_event_callback(msg):
    message_dict = {
        "type": msg.type}

    actual_list_flexray.append(message_dict)

def is_wus(flexray_event):
    return flexray_event["type"].name == "WUS"
