"""Module for group-wide constant values"""
from .helper import np, BusType, ListeningFlags
EXPECTED_NBR_CAN_ERR_FRAMES = 4
EXPECTED_NBR_FR_ERR_FRAMES = 2
EXPECTED_NBR_FR_EVENT_FRAMES = 1
ETH_SWITCH_CHANNEL = "Ethernet_Switch"
CAN_CM_CHANNEL = "Can_Ch_2"
FR_CM_CHANNEL = "B1_FlexRay"
CAN_TYPE = BusType.CAN
FLEXRAY_TYPE = BusType.FLEXRAY
INCLUDE_FRAMES_WITH_ERROR = ListeningFlags.INCLUDE_FRAMES_WITH_ERROR

# Each message corresponds to a TECMP logging stream, with data flags configured 
# based on the errored flag being set to 1.
CRC_CAN_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                        0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                        0xeb, 0x0d, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00,
                        0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00,
                        0x16, 0x69, 0x34, 0x37, 0xe6, 0x10, 0x00, 0x0f,
                        0x60, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x01,
                        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x00,
                        0x00], dtype=np.uint8)

HEADER_CRC_FR_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                              0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                              0x3f, 0xdb, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00,
                              0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0x00, 0x06,
                              0x15, 0xb6, 0x48, 0xca, 0x63, 0x80, 0x00, 0x19,
                              0x10, 0x00, 0x00, 0x00, 0x39, 0x10, 0x00, 0x00,
                              0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                              0x05, 0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x17,
                              0xb1, 0xd7, 0x41], dtype=np.uint8)

FRAME_CRC_FR_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                             0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                             0x3f, 0xdb, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00,
                             0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0x00, 0x06,
                             0x15, 0xb6, 0x48, 0xca, 0x63, 0x80, 0x00, 0x19,
                             0x20, 0x00, 0x00, 0x00, 0x39, 0x10, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x06, 0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x17,
                             0xb1, 0xd7, 0x41], dtype=np.uint8)

CRC_DEL_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                        0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                        0xeb, 0x01, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00,
                        0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00,
                        0x16, 0x69, 0x34, 0x08, 0xe9, 0x58, 0x00, 0x0f,
                        0x40, 0x21, 0x00, 0x00, 0x00, 0x01, 0x08, 0x01,
                        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x01, 0x4e,
                        0x7f], dtype=np.uint8)

NOT_ACK_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                        0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                        0xeb, 0x01, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00,
                        0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00,
                        0x16, 0x69, 0x34, 0x08, 0xe9, 0x58, 0x00, 0x0f,
                        0x40, 0x21, 0x00, 0x00, 0x00, 0x01, 0x08, 0x01,
                        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x01, 0x4e,
                        0x7f], dtype=np.uint8)

ACK_DEL_ERR = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                        0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                        0xeb, 0x09, 0x03, 0x03, 0x00, 0x02, 0x00, 0x00,
                        0x00, 0x07, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00,
                        0x16, 0x69, 0x34, 0x30, 0x50, 0x58, 0x00, 0x0f,
                        0x40, 0x41, 0x00, 0x00, 0x00, 0x01, 0x08, 0x01,
                        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x05, 0x16,
                        0xb0], dtype=np.uint8)

WAKE_UP_FR_EVENT = np.array([0x01, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x38, 0x2a,
                             0x19, 0x00, 0x3e, 0x13, 0x99, 0xfe, 0x00, 0x40,
                             0x3f, 0xdb, 0x03, 0x03, 0x00, 0x08, 0x00, 0x00,
                             0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0x00, 0x06,
                             0x15, 0xb6, 0x48, 0xca, 0x63, 0x80, 0x00, 0x19,
                             0x00, 0x08, 0x00, 0x00, 0x39, 0x10, 0x00, 0x00,
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                             0x07, 0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x17,
                             0xb1, 0xd7, 0x41], dtype=np.uint8)