from .signal_last_value_fixture import SignalLastValueFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *


@metadata(
    tc_id="tca_check_ethernet_network",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCheckEthernetNetwork(SignalLastValueFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_check_ethernet_network starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_check_ethernet_network stopping")

    # Create the test case core method that holds the main test steps.
    def test_check_ethernet_network(self):

        # Start an ethernet simulation by ecu name.
        self.test_features_simulation.start_ethernet_simulation(
            ECU_NAME)
        sleep(1)

        # Set the signal value of a specific npdu.
        self.test_features_simulation.set_ethernet_network(
            SIGNAL_PATH, SIGNAL_VALUE)
        sleep(2)

        # Check the preset signal value of a specific npdu.
        # This method can be used to check a value from a database file(.db)
        # that is not set by the user.
        check = self.test_features_simulation.check_ethernet_network(
            SIGNAL_PATH, EXPECTED_SIGNAL_VALUE)
        sleep(1)

        # Stop the ethernet simulation.
        self.test_features_simulation.stop_ethernet_simulation(ECU_NAME)

        # Assert the return value of the check_ethernet_network() to ensure the
        # correct value has been.
        self.assertTrue(check, Severity.BLOCKER,
                        "The signal value has not been set correctly")