from .pdu_last_value_fixture import PduLastValueFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_get_pdu_last_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaGetPduLastValue(PduLastValueFixture):

    # This method will be executed just before
    # the test case core method execution.
    def setUp(self):
        self.logger.info("tca_get_pdu_last_value starting")

    # This method will be executed just after
    # the test case core method execution.
    def tearDown(self):
        self.logger.info("tca_get_pdu_last_value stopping")

    # Create the test case core method that holds the main test steps.
    def test_get_pdu_last_value_little_endian(self):
        
        # Choose a frame id from the database and start the transmission. 
        # This frame contains two signals with the value of the CRC and counter,
        # The rest of signals have the default value 0xff.
        self.legacy_frame(CHANNEL_NAME,FRAME_ID).start_transmission()
        
        sleep(0.5)
        
        # Select a PDU name that corresponds to the specified frame ID, and modify a chosen
        # number of bytes in this PDU using user-defined values. The number of bytes to
        # modify is determined by the start bit and the bit number.
        self.legacy_pdu(CHANNEL_NAME,FRAME_ID,PDU_NAME).set_pdu_bits_value(SIGNAL_VALUE_LIST,
                                                                           START_BIT_1,
                                                                           BIT_NUMBER_1,
                                                                           BIT_ORDER_LE,
                                                                           False)
        
        # Retrieve a list of bytes representing the signals with their latest modified values.
        data = self.legacy_pdu(CHANNEL_NAME,FRAME_ID,PDU_NAME).get_last_value()
        
        # Extract the bytes corresponding to the bit range defined by start_bit and
        # (start_bit + bit_number). The division by 8 is used to convert bit indices
        # into byte indices.
        START_BYTE = START_BIT_1//8
        
        LAST_BYTE = (START_BIT_1+BIT_NUMBER_1)//8
        
        changed_data = data[START_BYTE:LAST_BYTE]
        
        # Verify that the bytes covering the range from start_bit to start_bit + bit_number 
        # remain unchanged and retain their default values, since the boolean flags update 
        # and send are set to False, meaning no update should occur.
        self.assertEqual(changed_data,
                         DEFAULT_VALUE_LIST,
                         Severity.BLOCKER,
                         "First PDU bytes are not kept at their default value.")
        
                            # Case 2: update_and_send = True
        # ------------------------------------------------------------------------------------------
        
        # Update the start bit and bit number parameters to modify a second signal within the same PDU,
        # using another user-defined value. When the update_and_send boolean flag is set to True,
        # both the first and second signals are updated with their respective defined values.
        self.legacy_pdu(CHANNEL_NAME,FRAME_ID,PDU_NAME).set_pdu_bits_value(SIGNAL_VALUE,
                                                                           START_BIT_2,
                                                                           BIT_NUMBER_2,
                                                                           BIT_ORDER_LE,
                                                                           True)
        
        sleep(0.5)
        
        # Retrieve a list of bytes representing the signals with their latest modified values.
        data = self.legacy_pdu(CHANNEL_NAME,FRAME_ID,PDU_NAME).get_last_value()
        
        # Verify that the bytes spanning from the start bit to start_bit + bit_number
        # have been updated to the expected values for the first signal.
        START_BYTE = START_BIT_1//8
        
        LAST_BYTE = (START_BIT_1+BIT_NUMBER_1)//8
        
        changed_data = data[START_BYTE:LAST_BYTE]
        
        self.assertEqual(changed_data,
                         SIGNAL_VALUE_LIST,
                         Severity.BLOCKER,
                         "First PDU bytes are not set correctly.")
        
        # Verify also that the last signal is updated to the expected value.
        self.assertEqual(data[-1],
                         SIGNAL_VALUE,
                         Severity.BLOCKER,
                         "Last PDU byte is not set correctly.")
        
        # Stop the transmission.
        self.legacy_frame(CHANNEL_NAME,FRAME_ID).stop_transmission()