from .io_fixture import IoFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id= "tca_set_io_value",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaSetIoValue(IoFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_set_io_value starting")

    # Create the tearDown() method.
    def tearDown(self):
        self.logger.info("tca_set_io_value stopping")

    # Create the test case core method that holds the main test steps.
    def test_set_io_value(self):

        value = self.io_controller.set_io_value(IO_CH_1, IO_SET_VALUE)

        self.assertTrue(value,
                        Severity.BLOCKER,
                        "An issue occured while trying to set an IO value")
