from .some_ip_fixture import SomeIpFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_someip_member",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureSomeipMember(SomeIpFixture):

    # Create setUp() method.
    def setUp(self):
        self.logger.info("tca_capture_someip_member starting")

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()

        self.logger.info("tca_capture_someip_member stopping")

    def test_capture_someip_member(self):


        # Change the IP of the sender channel to IP_57.
        change_ip(IP_57, ETH_SENDER_CH)
        # Change the IP of the receiver channel to IP_64.
        change_ip(IP_64, ETH_RECEIVER_CH)

        # Retrieve ECU4 and ECU2 instances for Ethernet communication.
        ECU4_ETHERNET = Ecu.try_get_ecu_by_name(ECU_4)
        ECU2_ETHERNET = Ecu.try_get_ecu_by_name(ECU_2)

        # Activate ECU2 and ECU4 Ethernet communication.
        ECU2_ETHERNET.activate()
        ECU4_ETHERNET.activate()

        # Get the service from ECU4 by service name or ID.
        service = ECU4_ETHERNET.try_get_provided_service_by_name_or_id(SERVICE_ID_1)

        # Get the message/event from the service using its method ID.
        event = service.try_get_message_by_id(METHOD_ID_1)

        sleep(1)

        # Retrieve a specific member (field) from the event by path.
        member = event.try_get_simple_member_by_path(MEMBER_PATH)

        # Set a value to the member.
        member.set_value(MEMBER_SET_VALUE)

        # Start listening to the member’s values using the callback function.
        member.start_listening(callback_fnc)

        # Serialize and transmit the SOME/IP message to trigger data exchange.
        event.try_serialize_and_transmit()

        sleep(1)

        # Stop listening to the member after message is received.
        member.stop_listening()

        # Assert that at least one value was captured during listening.
        self.assertTrue(len(struct) != 0, Severity.BLOCKER, 'No member value was captured')

        # Verify that all captured values match the expected set value.
        for value in range(len(struct)):
            self.assertTrue(struct[value] == MEMBER_SET_VALUE, Severity.BLOCKER, 'Member value mismatch')

        # Deactivate ECU2 and ECU4 after test.
        ECU2_ETHERNET.deactivate()
        ECU4_ETHERNET.deactivate()