"""Module for helper functions and group-wide utilities"""
import subprocess
from time import sleep
from mtf.libs.mtf_pybinder import Ecu
from mtf.libs.mtf_pybinder import SomeIpMessageAddress, SomeIpSimpleMember, mtf_timestamp, SomeIPMessageType



def get_current_ipv4(adapter):
    output = subprocess.check_output(f'netsh interface ip show address name="{adapter}"', shell=True, text=True)
    for line in output.splitlines():
        if "IP Address" in line or "IP Address:" in line:
            return line.split(":")[-1].strip()
    return None

def change_ip(ip, adapter, ipv6=None):
    current_ipv4 = get_current_ipv4(adapter)
    if current_ipv4 != ip:
        print(f"Changing IPv4 from {current_ipv4} to {ip}")
        change_ipv4 = f'netsh interface ip set address name="{adapter}" static {ip} 255.255.0.0'
        subprocess.call(change_ipv4.split())
    else:
        print("IPv4 already set to desired value. Skipping.")

    sleep(2)

struct = []

# Callback function triggered when a value is received from a SOME/IP member.
def callback_fnc(
        message_address: SomeIpMessageAddress,  
        member: SomeIpSimpleMember,            
        timestamp: mtf_timestamp,              
        path: str):               
    global struct
    # Append the last read value from the SOME/IP member to the global list 'struct'.
    struct.append(member.get_last_read_value())

raw_payload = []

def callback_fnc_m(
    message_address: SomeIpMessageAddress,
    payload: list[int],
    timestamp: mtf_timestamp,
    message_type: SomeIPMessageType):
    global raw_payload
    raw_payload.append(payload)
    
