from .npdu_fixture import NPDUFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_npdu_frame",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureNpduFrame(NPDUFixture):
    def setUp(self):
        self.logger.info("tca_capture_npdu_frame starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_Npdu_frame(self):

        # Add an input tunnel to the Npdu transmitter manager's configuration.
        self.npdu_manager.add_input_pdu_tunnel(
            channel_name=TUNNEL_SENDER,
            multi_cast_ip_v4_addresses=MULTI_CAST_IP_V4_ADDRESSES,
            multi_cast_port=MULTI_CAST_PORT,
            remote_ip_v4_address=REMOTE_IP_V4_ADDRESS,
            local_port=LOCAL_PORT,
            with_vlan_assign=WITH_VLAN_ASSIGN,
            force_add=FORCE_ADD,
            adapter_name=ETH_SENDER_CH)
        
        # Add an outpout tunnel to the Npdu listener manager's configuration.
        self.npdu_manager.add_output_pdu_tunnel(
              channel_name=TUNNEL_RECEIVER,
              multi_cast_ip_v4_addresses=MULTI_CAST_IP_V4_ADDRESSES,
              multi_cast_port=MULTI_CAST_PORT,
              transmission_timeout=TRANSMISSION_TIMEOUT,
              local_ip=REMOTE_IP_V4_ADDRESS,
              local_port=LOCAL_PORT,
              force_add=FORCE_ADD,
              adapter_name=ETH_RECEIVER_CH)
        
        # Start ndpu listener on TUNNEL_Receiver.
        # Listener result will be based on the tunnel 
        # parameters such as the ip addresses and the port.
        self.npdu_manager.start_npdu_listener(TUNNEL_RECEIVER)
        
        npdu_message = create_npdu_frame(
            PDU_ID, NPDU_DATA)
       
        self.npdu_manager.transmit(TUNNEL_SENDER, npdu_message, 0)
        
        sleep(0.5)

        # Stop the NPDU listener.
        self.npdu_manager.stop_npdu_listener(TUNNEL_RECEIVER)

        # Get a list of all the received npdu elements of channel_name.
        received_npdu_list =self.npdu_manager.get_all_received_npdu_data(TUNNEL_RECEIVER,True)
        
        self.assertEqual(len(received_npdu_list),
                         1,
                         Severity.BLOCKER,
                         "Wrong number of captured pdus.")
        
        npdu = received_npdu_list[0]
        
        self.assertTrue(npdu.npdu_element.pdu_id == PDU_ID, Severity.BLOCKER,
                        "The captured PDU is not as expected")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_npdu_frame stopping")