from .lin_fixture import LinFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_lin_frames",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureLinFrames(LinFixture):
    def setUp(self):
        self.logger.info("tca_capture_lin_frames starting")

    # Create the test case method that holds the main test steps.
    def test_capture_lin_frames(self):

        lin_ch = ChannelFactory().get_lin_channel(LIN_CHANNEL_NAME)

        lin_fr = lin_ch.get_frame(LIN_FRAME_ID)

        # Start listening on the lin channel.
        lin_ch.listener.start_listening()

        lin_fr.transmitter.transmit_frame(LIN_PAYLOAD)

        sleep(1)

        # Stop listening on the lin channel.
        lin_ch.listener.stop_listening()

        q = lin_ch.listener.get_queue()

        # Confirm that the queue is not Null object,
        # meaning there is no error in creating the queue.
        self.assertTrue(q is not None, Severity.BLOCKER,
                        "Error when listening to lin bus")

        # Confirm that queue is not empty meaning messages are received.
        self.assertTrue(not q.empty() >= 1, Severity.BLOCKER,
                        "Lin frame is not received")
        
        event = q.queue[0]

        self.assertTrue(event.frame_id == LIN_FRAME_ID, Severity.BLOCKER,
                        "LIN frame id mismatch")
        
        self.assertTrue(event.channel_name == LIN_CHANNEL_NAME, Severity.BLOCKER,
                        "LIN channel_name mismatch")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_lin_frames stopping")