from .flexray_fixture import FlexrayFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_flexray_tp_frames_with_callback",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureFlexrayTpFramesWithCallback(FlexrayFixture):
    def setUp(self):
        self.logger.info("tca_capture_flexray_tp_frames_with_callback starting")

    # Create the test case method that holds the main test steps.
    def test_capture_flexray_tp_frames_with_callback(self):
        
        # Create a FlexRay TP configuration based on the PDU length,
        # Flow timeout, addressing type and FlexRayTP standard type 
        # (AR TP ISO in our case).
        flexraytp_config = flexray_tp_config(ADDRESSING_TYPE,
                                             FLOW_TIMEOUT,
                                             PDU_LENGTH_AR_TP,
                                             AR_TP_ISO_TYPE)
        
        # Use the defined configuration, along with the addresses and frame IDs, 
        # to create two instances of FlexRay TP using the MTF FlexRay TP controller.
        mtf_controller_sender = mtf_flexray_tp_controller(FR_CHANNEL_2,
                                                          CONTROLLER_TX_FRAME_ID,
                                                          SOURCE_ADDRESS,
                                                          CONTROLLER_RX_FRAME_ID,
                                                          TARGET_ADDRESS,
                                                          flexraytp_config,
                                                          COMMUNICATION_CHANNEL)
        
        mtf_controller_receiver = mtf_flexray_tp_controller(FR_CHANNEL_1,
                                                            CONTROLLER_RX_FRAME_ID,
                                                            TARGET_ADDRESS,
                                                            CONTROLLER_TX_FRAME_ID,
                                                            SOURCE_ADDRESS,
                                                            flexraytp_config,
                                                            COMMUNICATION_CHANNEL)
    
        # Create a callback function and configure FlexRay TP instances with it. 
        # The callback will be used for transmission and capture of the communication traffic.
        flexray_callback = flexrayCallback()
        
        configure_sender = mtf_controller_sender.configure(flexray_callback.msg_callback)
        
        self.assertTrue(configure_sender, 
                        Severity.BLOCKER,
                        "MTF controller sender is not correctly configured.")
        
        configure_receiver = mtf_controller_receiver.configure(flexray_callback.msg_callback)
        
        self.assertTrue(configure_receiver, 
                        Severity.BLOCKER,
                        "MTF controller receiver is not correctly configured.")
        
        self.flexray_channel(FR_CHANNEL_1).start_listening()
        
        # Transmit the flexray tp frame with payload length more
        # than the pdu length.
        mtf_controller_sender.transmit(FR_AR_TP_PAYLOAD)
        sleep(2)
        
        self.flexray_channel(FR_CHANNEL_1).stop_listening()
        
        # Use the queue of the listener to catch different segments 
        # of the flexray tp message.
        queue_list = self.flexray_channel(FR_CHANNEL_1).get_history()
        
        actual_flexray_tp_list = []
        
        # Extract the slot ID and payload from each segment,
        # store them in a dictionary, and collect all dictionaries 
        # in a final list.
        for frame_packet in queue_list:
          packet_element = {
            "slot_id": frame_packet.frame_id & 0xffff,
            "payload": ([hex(num) for num in frame_packet.payload]),
            "payload_length": frame_packet.payload_length}
          actual_flexray_tp_list.append(packet_element)
        
        self.assertTrue(actual_flexray_tp_list==FLEXRAY_TP_EXPECTED_LIST, 
                        Severity.BLOCKER,
                        "Captured segmented FlexRay messages don't match expected ones.")
            
        mtf_controller_sender.cleanUp()
        
        mtf_controller_receiver.cleanUp()
        
    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_flexray_tp_frames_with_callback stopping")