"""Module for helper functions and group-wide utilities"""
from time import sleep
from mtf.network_port.channels.channel_factory import ChannelFactory
from mtf.diag_port.flexray_tp import FlexrayTp
from mtf.diag_port.flexray_tp_config import FlexrayTpConfig
from mtf import FRCommunicationChannel
from mtf.libs.mtf_pybinder import mtf_flexray_tp_controller, MtfFrTpConfig, MtfFrTpAddressLength, MtfFrTpType, FrFrameIdParts

def flexray_tp_config(addressing_type,flow_timeout_ms,pdu_length,tp_type):
    mtf_config = MtfFrTpConfig()
    mtf_config.addressing_type = addressing_type
    mtf_config.flow_timeout_ms = flow_timeout_ms
    mtf_config.pdu_length = pdu_length
    mtf_config.tp_type = tp_type
    return mtf_config

class flexrayCallback:
    def __init__(self):
        self.callback_list = []

    def msg_callback(self, channel_name, slot_id, offset, rep, target_address,
                          source_address, payload, timestamp):
        message_dict = {
            "channel_name": channel_name,
            "slot_id": slot_id,
            "offset": offset,
            "rep":rep,
            "target_address": target_address,
            "source_address": source_address,
            "payload": [hex(num) for num in payload]}
        self.callback_list.append(message_dict)
