"""Module for group-wide constant values"""
from .helper import MtfFrTpType, FRCommunicationChannel, MtfFrTpAddressLength, FrFrameIdParts
FR_CHANNEL_1 = 'B1_FlexRay'
FR_CHANNEL_2 = 'B2_FlexRay'
FR_FRAME_ID = '5.2.64'  # Its type is str.
FR_PAYLOAD = [0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xf, 0x10]

RX_FRAME_ID = "173.0.1"
CONTROLLER_RX_FRAME_ID = FrFrameIdParts(slot_id=173,offset=0,repetition=1)
TARGET_ADDRESS = 0x11
TX_FRAME_ID = "210.0.1"
CONTROLLER_TX_FRAME_ID = FrFrameIdParts(slot_id=210,offset=0,repetition=1)
SOURCE_ADDRESS = 0xf8
ADDRESSING_TYPE = MtfFrTpAddressLength.TWO_BYTES
PDU_LENGTH = 22
PDU_LENGTH_AR_TP = 10
FLOW_TIMEOUT = 2000
EXTENDED_FR_PAYLOAD = list(range(0, 25)) # For the ISO standard, the maximum length of the data list is 254.
FR_AR_TP_PAYLOAD = list(range(0, 15)) # For the AR TP ISO standard, the length of the data list should be represented in 4 bits(maximum 15).
AR_TP_ISO_TYPE = MtfFrTpType.AR_TP_ISO
COMMUNICATION_CHANNEL = FRCommunicationChannel.A

# This list represents a segmented Flexray-TP message divided into five frames,
# each segment is identified by the fifth element of the payload list:
# - The first frame(identified by 0x10) indicates a total payload length of 15 bytes 
#   and contains the first 4 bytes of application data with the source address 
#   and the target address represented in two bytes corresponding to the addressing type defined.
# - A received acquittement message (0x30) with payload length 8 and with same rules for target and source address.
# - Two consecutive frames (identified by 0x21 and 0x22) carries the next 10 bytes of data.
# - The final frame (identified by 0x22 in our case) includes the remaining data, followed by 
#   four padding bytes (0x0) according the stnadard to reach a total payload length of 10 bytes.
FLEXRAY_TP_EXPECTED_LIST = [{'slot_id': 210, 'payload': ['0x0', '0x11', '0x0', '0xf8', '0x10', '0xf', '0x0', '0x1', '0x2', '0x3'], 'payload_length': 10}, 
                            {'slot_id': 173, 'payload': ['0x0', '0xf8', '0x0', '0x11', '0x30', '0x0', '0x0', '0x0'], 'payload_length': 8}, 
                            {'slot_id': 210, 'payload': ['0x0', '0x11', '0x0', '0xf8', '0x21', '0x4', '0x5', '0x6', '0x7', '0x8'], 'payload_length': 10}, 
                            {'slot_id': 210, 'payload': ['0x0', '0x11', '0x0', '0xf8', '0x22', '0x9', '0xa', '0xb', '0xc', '0xd'], 'payload_length': 10}, 
                            {'slot_id': 210, 'payload': ['0x0', '0x11', '0x0', '0xf8', '0x23', '0xe', '0x0', '0x0', '0x0', '0x0'], 'payload_length': 10}]