from .ethernet_fixture import EthernetFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_encode_decode_someip_message",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaEncodeDecodeSomeipMessage(EthernetFixture):
    def setUp(self):
        self.logger.info("tca_encode_decode_someip_message starting")

    def test_encode_decode_someip_message_with_pcpp(self):

        # Start listening on an Ethernet channel.
        self.bus_manager.ethernet_listener(
            bus_name=BUS_NAME,
            protocol=SOMEIP_PROTOCOL_TYPE).start_listening()
        
        # Define a SOMEIP port.
        
        pcpp.SomeIpLayer.add_some_ip_port(DST_PORT)

        # Create an Ethernet raw packet.
        Raw_packet = pcpp.RawPacket(SOMEIP_MSG_PAYLOAD)

        self.addStep(
                f"Step 1.", 
                f" Set SOME/IP message elements (Encoding)")
        Ethernet_packet = pcpp.Packet(Raw_packet)
        SOMEIP_Layer = Ethernet_packet.get_layer_of_type(PCPP_SOMEIP_PROTOCOL_TYPE)
        SOMEIP_Layer.service_id = EXPECTED_SERVICE_IDENTIFIER
        SOMEIP_Layer.method_id = EXPECTED_METHOD_IDENTIFIER
        SOMEIP_Layer.client_id = EXPECTED_CLIENT_ID
        SOMEIP_Layer.session_id = EXPECTED_SESSION_ID
        SOMEIP_Layer.protocol_version = EXPECTED_PROTOCOL_VERSION
        SOMEIP_Layer.interface_version = EXPECTED_INTERFACE_VERSION
        SOMEIP_Layer.message_id = EXPECTED_MESSAGE_ID
        SOMEIP_Layer.request_id = EXPECTED_REQUEST_ID

        self.addStep(
                f"Step 2.", 
                f" Transmit the created Ethernet message")
        
        transmitter = mtf_ethernet_transmitter() 
        transmitter.transmit_ethernet_packet(BUS_NAME,Ethernet_packet)
       
        sleep(2)

        # Start listening on the Ethernet channel.
        self.bus_manager.ethernet_listener(
            bus_name=BUS_NAME, protocol=SOMEIP_PROTOCOL_TYPE).stop_listening()

        # Get the queue of the Ethernet listener.
        messages = self.bus_manager.ethernet_listener(
            bus_name=BUS_NAME, protocol=SOMEIP_PROTOCOL_TYPE).get_queue()


        actual_someip_header_dict = {}
        self.addStep(
                f"Step 3.", 
                f" Decoding SOME/IP messages elements.")
        for someip_message in messages:
            
            someip_header = get_someip_header(someip_message)

            actual_someip_header_dict[SERVICE_IDENTIFIER] = hex(someip_header.service_identifier)
            actual_someip_header_dict[METHOD_IDENTIFIER] = hex(someip_header.method_identifier)
            actual_someip_header_dict[LENGTH] = someip_header.length
            actual_someip_header_dict[CLIENT_ID] = someip_header.client_id
            actual_someip_header_dict[SESSION_ID] = someip_header.session_id
            actual_someip_header_dict[MESSAGE_TYPE] = someip_header.message_type.ToString()
            actual_someip_header_dict[RETURN_CODE] = someip_header.return_code.ToString()
            actual_someip_header_dict[PROTOCOL_VERSION] = someip_header.protocol_version
            actual_someip_header_dict[INTERFACE_VERSION] = someip_header.interface_version
            actual_someip_header_dict[MESSAGE_ID] = hex(someip_header.message_id)
            actual_someip_header_dict[REQUEST_ID] = someip_header.request_id


        # Check that the received SOME/IP header dictionary equals
        # the expected SOME/IP header dictionary.
        self.assertEqual(actual_someip_header_dict,
                         EXPECTED_SOMEIP_HEADER_DICT,
                         Severity.BLOCKER,
                         'Wrong SOME/IP header data actual{0}, expected:{1}'.format(actual_someip_header_dict, 
                                                                                    EXPECTED_SOMEIP_HEADER_DICT))

    # Create the tearDown() method.
    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_encode_decode_someip_message stopping")