from .ethernet_fixture import EthernetFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_ptp_message",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCapturePtpMessage(EthernetFixture):
    def setUp(self):
        self.logger.info("tca_capture_ptp_message starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_ptp_message(self):

        actual_ptp_dict = {}

        # Start the listener on PTP frames captured on the specified adapter.
        self.bus_manager.ethernet_listener(
            bus_name=ADAPTER_NAME,
            protocol=PTP_PROTOCOL_TYPE).start_listening()

        # Transmit a frame with the specified data and adapter_name.
        self.bus_manager.bus_transmitter(
            ETH_BUS_TYPE).transmit_frame(
            ADAPTER_NAME, PTP_DATA)
        sleep(1)

        # Stop the listener.
        self.bus_manager.ethernet_listener(
            bus_name=ADAPTER_NAME,
            protocol=PTP_PROTOCOL_TYPE).stop_listening()
        
        # Get the queue of captured PTP frames.
        messages = self.bus_manager.ethernet_listener(
            bus_name=ADAPTER_NAME, protocol=PTP_PROTOCOL_TYPE).get_queue()
        
        self.assertTrue(len(messages)!=0, Severity.BLOCKER,"The listener's queue is empty")

        # Collect the captured message's information in the actual_ptp_dict.
        for message in messages:
            actual_ptp_dict[MESSAGE_ID_KEY] = str(message[PTP_MESSAGE_KEY].message_id)
            actual_ptp_dict[MESSAGE_TYPE_KEY] = str(message[PTP_MESSAGE_KEY].message_type)

        self.assertEqual(actual_ptp_dict, EXPECTED_PTP_DICT, Severity.BLOCKER,"PTP message data mismatch")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_ptp_message stopping")