from .ethernet_fixture import EthernetFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_capture_ethernet_payloads",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureEthernetPayloads(EthernetFixture):
    def setUp(self):
        self.logger.info("tca_capture_ethernet_payloads starting")

     # Create the test case method that holds the main test steps.
    def test_capture_ethernet_payloads(self):

        eth_ch = ChannelFactory().get_ethernet_channel(ADAPTER_NAME)

        # Start listening on the ethernet channel.
        eth_ch.listener.start_listening()

        # Transmit an ethernet payload.
        eth_ch.transmitter.transmit_frame(ETH_PAYLOAD)

        sleep(1)

        # Stop listening on the ethernet channel.
        eth_ch.listener.stop_listening()

        q = eth_ch.listener.get_queue()

        # Confirm that the queue is not Null object,
        # meaning there is no error in creating the queue.
        self.assertTrue(q is not None, Severity.BLOCKER,
                        "Error when listening to the ethernet bus")

        # Confirm that queue is not empty meaning messages are received.
        self.assertTrue(len(q) >= 1, Severity.BLOCKER,
                        "Ethernet payload is not received")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests.
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_ethernet_payloads stopping")