"""Module for helper functions and group-wide utilities"""
import numpy as np
from time import sleep
from mtf.proto_common import EthProtocolType
from mtf.network_port.channels.channel_factory import ChannelFactory
from mtf.enum_types import BusType
from mtf.libs.mtf_pybinder import pcpp, mtf_ethernet_transmitter, mtf_someip_filter, mtf_ipv4_layer_filter, mtf_udp_layer_filter, mtf_eth_app_layer_filter, mtf_eth_protocol_type

def get_someip_header(someip_message):
    someip_header = someip_message['someip_message'].someip_header
    return someip_header

def create_someip_filter(ip_src,service_id,method_id,msgType):
    ipv4_layer_filter = mtf_ipv4_layer_filter()
    ipv4_layer_filter.ip_srcs = ip_src

    udp_layer_filter = mtf_udp_layer_filter()
    udp_layer_filter.prev_layer_filter = ipv4_layer_filter

    eth_app_layer_filter = mtf_eth_app_layer_filter()
    eth_app_layer_filter.app_layer_protocol_type = mtf_eth_protocol_type.SOME_IP
    eth_app_layer_filter.prev_layer_filter = udp_layer_filter

    someip_filters = mtf_someip_filter()
    someip_filters.services_ids = service_id
    someip_filters.methods_ids = method_id
    someip_filters.msg_type = msgType

    return someip_filters