from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *


@metadata(
    tc_id="tca_capture_can_tp_frames_with_callback",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanTpFramesWithCallback(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_tp_frames_with_callback starting")

    # Create the test case method that holds the main test steps.
    def test_capture_can_tp_frames_with_callback(self):
        
        # Create two instances of the CanTP class and configure them with the 
        # required parameters.Certain parameters values must be inverted 
        # between the sender and receiver (e.g.,RX and TX frame IDs,or source 
        # and target addresses) to properly establish communication.
        can_sender= CanTp()
        
        can_receiver= CanTp()

        can_sender.Configure(CAN_CM_CHANNEL_1,
                             RX_FRAME_ID,
                             TX_FRAME_ID,
                             CAN_PROTOCOL_TYPE,
                             PDU_LENGTH,
                             PADDING_VALUE,
                             FLOW_TIMEOUT,
                             source_address=SOURCE_ADDRESS,
                             target_address =TARGET_ADDRESS)
        
        can_receiver.Configure(CAN_CM_CHANNEL_2,
                               TX_FRAME_ID,
                               RX_FRAME_ID,
                               CAN_PROTOCOL_TYPE,
                               PDU_LENGTH,
                               PADDING_VALUE,
                               FLOW_TIMEOUT,
                               source_address=TARGET_ADDRESS,
                               target_address =SOURCE_ADDRESS)
        
        # When the can sender send a data with size more than 8 bytes
        # (14 bytes in our example), each segmented message will be 
        # captured by the listener.
        can_frame_listener = self.can_frame_listener(CAN_CM_CHANNEL_2,
                                                     TX_FRAME_ID)
        
        # A callback is used to catch different segments of the message. 
        can_frame_listener.start_listening(silent_mode=False,
                                           callback=can_tp_callback)
        
        can_sender.send(EXTENDED_CAN_PAYLOAD)
        
        sleep(1.5)
        
        can_frame_listener.stop_listening()
        
        # Message segments will be collected in the callback list, 
        # each segment is represented by a dict that contains the 
        # reception frame id, the target address and the list of bytes
        # transmitted in the segment.
        self.assertTrue(actual_can_tp_list==CAN_TP_EXPECTED_LIST, 
                        Severity.BLOCKER,
                        "Captured segmented can messages doesn't match the expected ones")
         
        can_sender.close()
        
        can_receiver.close()

    def tearDown(self):
        # Clean up any remaining test resources.
        self.cleanup_all_controllers()
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_tp_frames_with_callback stopping")