from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_can_frames",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanFrames(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_frames starting")

    # Create the test case method that holds the main test steps.
    def test_capture_can_frames(self):

        can_ch = ChannelFactory().get_can_channel(CAN_CHANNEL_NAME, False)

        can_fr = can_ch.get_frame(CAN_FRAME_ID)

        # Start listening on the can channel.
        can_ch.listener.start_listening()

        # Transmit the frame.
        can_fr.transmitter.transmit_frame(CAN_PAYLOAD)

        sleep(1)

        # Stop listening on the can channel
        can_ch.listener.stop_listening()

        q = can_ch.listener.get_queue()

        # Confirm that the queue is not Null object,
        # meaning there is no error in creating the queue.
        self.assertTrue(q is not None, Severity.BLOCKER,
                        "Error when listening to the can bus")

        # Confirm that queue is not empty meaning messages are received.
        self.assertTrue(not q.empty(), Severity.BLOCKER,
                        "Can frame is not received")
        
        event = q.queue[0]

        self.assertTrue(event.frame_id == CAN_FRAME_ID, Severity.BLOCKER,
                        "Can frame id mismatch")
        
        self.assertTrue(event.channel_name == CAN_CHANNEL_NAME, Severity.BLOCKER,
                        "Can channel_name mismatch")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_frames stopping")
