from .can_fixture import CanFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .helper import *
from .config import *

@metadata(
    tc_id="tca_capture_can_cyclic_transmission",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCaptureCanCyclicTransmission(CanFixture):
    def setUp(self):
        self.logger.info("tca_capture_can_cyclic_transmission starting")

    # Create the test case method that holds the main test steps.
    def test_capture_can_cyclic_transmission(self):

        can_ch = ChannelFactory().get_can_channel(CAN_CHANNEL_NAME, False)

        # Retrieve the desired can frame object associated with the 
        # frame_id.
        can_frame = can_ch.get_frame(CAN_FRAME_ID)

        # Start listening on the can fd channel.
        can_ch.listener.start_listening()

        # Start cyclic transmission of the frame.
        cyclicity = can_frame.transmitter.start_transmit_cyclic_frame(CAN_PAYLOAD, CYCLE) # cycle unit in μs

        sleep(2)
        
        # Stop cyclic transmission of the frame.
        can_frame.transmitter.stop_transmit_cyclic_frame()

        # Stop listening on the can fd channel.
        can_ch.listener.stop_listening()

        queue = can_ch.listener.get_queue()

        # Confirm that start_transmit_cyclic_frame is started successfully.
        self.assertTrue(cyclicity, Severity.BLOCKER,
                        "start_transmit_cyclic_frame is started successfully")
        
        # CYCLE = 500000 μs = 0.5 ms * 4 = 2s (sleep time)
        # Expected cycle is 4 or 5 due to performance issue.
        self.assertTrue(queue.qsize() in [4, 5], Severity.BLOCKER,
                        "cycle is not respected")

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_can_cyclic_transmission stopping")