from .pdu_fixture import PduFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_pdu_frame_with_callback",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCapturePduFrame(PduFixture):
    def setUp(self):
        self.logger.info("tca_capture_pdu_frame_with_callback starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_pdu_frame_with_callback(self):
        
        # Define an instance of the pdu callback class.
        pduCallback = pdu_callback()
        
        # Define a PDU listener class to capture traffic for 
        # a specific PDU name and frame ID. The on_change=True 
        # flag ensures that the listener will only capture
        # frames when any signal value changes.
        pdu_listener = PduListener(channel_name=CHANNEL_NAME,
                                   frame_id=FRAME_ID, 
                                   pdu_name=PDU_NAME, 
                                   on_change=True)
        
        # Attach the message callback function to the listener so it can be used 
        # instead of the queue. Each PDU message returned by this callback is 
        # represented as a dictionary containing both the full path and the signal values.
        pdu_listener.register_callback(callback_fnc=pduCallback.msg_callback)
        
        # Define a class channel with the same channel name for the transmission.
        channel = self.com_network.try_get_channel_by_name(CHANNEL_NAME)
        
        self.assertTrue(channel, Severity.BLOCKER,
                        "Channel is not found")
        
        # Start the listener with silent mode false 
        # to get the pdu messages via callback function.
        pdu_listener.start_listening(silent_mode=False)
        
        # Start the frame transmission. Since the transmission is cyclic and uses 
        # the same default values, the listener will capture only a single frame
        # in the callback.
        channel.get_frame_by_id(int(FRAME_ID,16)).start_transmission()

        sleep(1)
        
        # Stop the transmission.
        channel.get_frame_by_id(int(FRAME_ID,16)).stop_transmission()
        
        # Stop the listener
        pdu_listener.stop_listening()
        
        # Assert that the callback list include only one frame.
        self.assertEqual(len(pduCallback.actual_pdu_list),
                         1,
                         Severity.BLOCKER,
                         "Wrong number of captured pdus")
        
        # Retrieve the callback list and assert that it matches the 
        # expected pdu list.
        self.assertEqual(pduCallback.actual_pdu_list,
                         EXPECTED_PDU_LIST, 
                         Severity.BLOCKER,
                        "The captured PDU is not as expected")
        
        # Reset the pdu listener to clean the queue.
        pdu_listener.reset()

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_pdu_frame_with_callback stopping")