from .pdu_fixture import PduFixture
from xtr import Severity
from xtr import metadata, extra_metadata
from .config import *
from .helper import *


@metadata(
    tc_id="tca_capture_pdu_frame",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaCapturePduFrame(PduFixture):
    def setUp(self):
        self.logger.info("tca_capture_pdu_frame starting")

    # Create the test case core method that holds the main test steps.
    def test_capture_pdu_frame(self):
        
        # Define a PDU listener class to capture traffic for 
        # a specific PDU name and frame ID. The on_change=True 
        # flag ensures that the listener will only capture
        # frames when any signal value changes.
        pdu_listener = PduListener(channel_name =CHANNEL_NAME,
                                   frame_id =FRAME_ID, 
                                   pdu_name =PDU_NAME, 
                                   on_change=True)
        
        # Define a class channel with the same channel name for the transmission.
        channel = self.com_network.try_get_channel_by_name(CHANNEL_NAME)
        
        self.assertTrue(channel, Severity.BLOCKER,
                        "Channel is not found")
        
        # Start the listener.
        pdu_listener.start_listening()
        
        # Start the frame transmission. Since the transmission is cyclic and uses 
        # the same default values, the listener will capture only a single frame.
        channel.get_frame_by_id(int(FRAME_ID,16)).start_transmission()

        sleep(1)
    
        channel.get_frame_by_id(int(FRAME_ID,16)).stop_transmission()
        
        # Stop the listener.    
        pdu_listener.stop_listening()
        
        # Get the queue list.
        queue_list = pdu_listener.get_queue()
        
        # Assert that the queue contains only one frame.
        # Each frame element in the queue is represented by a tuple including
        # the path the timestamp and a list of pdu signal values.
        self.assertEqual(len(queue_list),
                         1,
                         Severity.BLOCKER,
                         "Wrong number of captured pdus.")
        
        # Retrieve the pdu path and the pdu value from the queue.
        
        pdu_result= queue_list[0]
         
        pdu_path = pdu_result[0]

        pdu_value = pdu_result[2]
        
        # Verify that the results match the complete path defined in the database 
        # and that the signal values correspond to their default values.
        self.assertEqual(pdu_path,
                         PDU_PATH, 
                         Severity.BLOCKER,
                         "The captured PDU path is not as expected")
        
        self.assertEqual(pdu_value,
                         PDU_VALUE, 
                         Severity.BLOCKER,
                         "The captured PDU value is not as expected")
        
       
        # Clean the pdu listener queue. 
        pdu_listener.clean_up()

    def tearDown(self):
        self.cleanup_all_controllers()
        # Clean up all network listeners to avoid interference with other tests
        self.bus_manager.cleanup_all_listeners()
        self.logger.info("tca_capture_pdu_frame stopping")