from .Diagnostics_Fixture import FixtureDiagnostic
from xtr import metadata, extra_metadata, Severity

from .config import *
from .helper import *

@metadata(
    tc_id="tca_diagnostics",
    description="",
    status="Design",
    authors=["YourName"],
    domain="",
    targets=[("TargetEcu", True)],
    testbench_types=["S", "M", "L"],  # TB Type: S, L ... where I can run this testcase
)
@extra_metadata(
    extra_metadata_1="Some important extra metadata",
)
class TcaDiagnostics(FixtureDiagnostic):
    def setUp(self):

        self.logger.info("tca_diagnostics starting")

    def tearDown(self):

        self.logger.info("tca_diagnostics stopping")

    def test_diagnostics(self):

        self.addStep(
                f"Step 1.", 
                f" Create a DoIP server")

        server = DoipServer(ip=SERVER_IP, 
                            port=DOIP_PORT, 
                            logical_address=LOGICAL_ADDRESS)
        
        server.vin = VIN
        server.eid = EID
        server.gid = GID

        self.addStep(
                f"Step 2.", 
                f" Start the server")
        
        server.start()
        
        # Create a client controller instance.
        diag_controller = EthDiagController(source_address=TESTER_ADDRESS, 
                                            target_address=LOGICAL_ADDRESS,
                                            destination_ip=SERVER_IP,
                                            diag_protocol=DIAG_PROTOCOL, 
                                            protocol_version=PROTOCOL_VERSION)

        self.addStep(
                f"Step 3.", 
                f" Send first request with positive response")
        
        server.positive_responding = True
        server.positive_response_data = SERVER_POSITIVE_RESPONSE_DATA
        resp = diag_controller.sync_send_interpret_response(INTERPRET_RESPONSE)
        self.assertTrue(resp.positive, Severity.BLOCKER, '***Failure: expected positive response but got negative response')

        self.addStep(
                f"Step 4.", 
                f" Send second request with negative response")
        
        server.positive_responding = False
        resp = diag_controller.sync_send_interpret_response(INTERPRET_RESPONSE)
        self.assertFalse(resp.positive, Severity.BLOCKER,'***Failure: expected negative response but got postive response')

        self.addStep(
                f"Step 5.", 
                f" Stop the server")

        server.stop()