To run the test cases in this project, you need:

1. The provided database file to be compatible with the MTF version you are using.
2. A Microsoft Loopback Ethernet Adapter.
3. A physical ethernet loop is required to run some test cases as we are using the method change ip to change dynamically its ip to simulate an ecu(Run as administartor is mandatory to change the ip).

#### **Notes**:

* If no physical adapters are available, you can run the test cases that only require virtual adapters using the yaml located in mtf_advanced_tuto config folder.
* The yaml file in the config folder must be updated with the convenient friendly adapter names(physical adapter names). 
* Some test cases requires capture modules for CAN, LIN and FlexRay.

# First step: check/update database file

Before running this tutorial project, you need to check if the database file in "mtf_basic_tuto/config/Databases" 
was generated with a DaTaBeX version identical to the DaTaBeX version of the MTF you are using to run the test cases.

To perform this check, execute the **generate_db_file.py** script. This script compares the two DaTaBeX versions and generates
a new database file if they are different.

You can run the script either from your IDE, or using the following command:

```cmd
python generate_db_file.py
```

# Second step: install/prepare the Microsoft Loopback ETHERNET Adapter

## Install the Microsoft Loopback ETHERNET Adapter

### Method 1

1- Run Command Prompt as administrator and run the command `hdwwiz.exe`:

![alt text](microsoft_loopback_ethernet_adapter/1.png)

2- Click Next:

![alt text](microsoft_loopback_ethernet_adapter/2.png)

3- Select `Install the hardware that I manually select from a list (Advanced)`. Then Click Next:

![alt text](microsoft_loopback_ethernet_adapter/3.png)

4- Scroll down the list and go till you see `Network adapters` in the list, and when you see, select it as shown below. Then Click Next:

![alt text](microsoft_loopback_ethernet_adapter/4.png)

5- On the left hand panel (Manufacturer list), scroll down and look out for `Microsoft`:

![alt text](microsoft_loopback_ethernet_adapter/5.png)

6- Now scroll down the right hand side list and look for `Microsoft KM-TEST Loopback Adapter` in the list. Select it as shown below. Then Click Next:

![alt text](microsoft_loopback_ethernet_adapter/6.png)

7- Once you click Next, windows will create the adapter and the finish window will appear as below:

![alt text](microsoft_loopback_ethernet_adapter/7.png)

8- Click Finish in the last window.

![alt text](microsoft_loopback_ethernet_adapter/8.png)

9- Check the adapter is created.

![alt text](microsoft_loopback_ethernet_adapter/10.png)


### Method 2

1- Open Command Prompt as administrator.


2- Using the `cd` command to change folder to `mtf_tutorials\mtf_basic_tuto\microsoft_loopback_ethernet_adapter` .


3- Run bat file "add_loopback_ethernet_adapter.bat":

![alt text](microsoft_loopback_ethernet_adapter/9.png)

4- Check the adapter is created:

![alt text](microsoft_loopback_ethernet_adapter/10.png)


## Change the name of the adapter created in the last step and configure the needed IP address

1- Changing the name of the adapter to `Ethernet_MTF`

![alt text](microsoft_loopback_ethernet_adapter/11.png)

2- Open Command Prompt as administrator.


3- Run python script `mtf_tutorials\mtf_basic_tuto\microsoft_loopback_ethernet_adapter\set_ips_address.py` which is located under `microsoft_loopback_ethernet_adapter` folder.

![alt text](microsoft_loopback_ethernet_adapter/12.png)

# Third step: Run the test cases

To run the test cases, you can use the xtr command:

```
xtr --output_path result core --config config/TestBenchConfigs/MTF_test_tb/All_bus_types_config_file.yaml --database config/Databases/CANFD_Ethernet.db run --test_series config/TestSeries/All_mtf_tutos.xml --search_paths tests
```

You can also use the launch.json file. You need to update it with the path to xtr.exe,
then you simply click Run in VS Code.
Executing tests using launch.json allows you to run them either without debugging or in debug mode. 
